# Caveats
## packer
* Version 1.4.1 and 1.4.2 fails to copy files outputs
## docker
#### DNS
- You may need to point docker directly to one of our internal primary DNS servers
- A reload/restart of docker will be required

`/etc/docker/daemon.json`
```
{
    "dns": ["10.254.0.3"]
}
```

#### Proxy
- Depending on your network access to the internet and internal twitch network, you may need to set proxy servers. See docker [proxy documentation] on how to do this for the version of docker you have installed.

`config.json` working example:
```
{
 "proxies":
 {
   "default":
   {
     "httpProxy": "http://proxy.internal.justin.tv:9797/",
     "httpsProxy": "http://proxy.internal.justin.tv:9797/",
     "noProxy": "localhost,127.0.0.1,127.0.1.1,127.0.0.0/8,169.254.0.0/16,199.9.248.0/21,192.16.64.0/21,10.0.0.0/8,internal.justin.tv,internal.twitch.tv,justin.tv,.twitch.tv,jtvnw.net,169.254.169.254,pypi.internal.justin.tv"
   }
 }
}
```

[proxy documentation]: https://docs.docker.com/network/proxy/
