# Contributing

## Making Changes

Contributions to this repository:
- should be reviewed via [Pull Requests](CONTRIB.md#pull-requests) before merging.
- must follow the [Code Contribution Guidelines].
- See the [Code Contribution Checklist] for a quick reference.

## Pull Requests
All pull requests must:
  - Have a description explaining the problem
  - Snippet of any output error
  - Snippet of any output showing the fixed results
  - Contain a link to a JIRA ticket
  - Have been linted:
   - `puppet-lint`
   - `flake8`
   - `puppet validate`
   - etc
  - Not contain lint errors. Run all new code through `puppet-lint`.

## Code Reviews

If you need help finding a reviewer, ping the [#video-coreservices] Slack
channel. More information on how to get started can be found in the
[README](README.md).


[#video-coreservices]: https://twitch.slack.com/messages/CEVFAMMLH/
[Code Contribution Guidelines]: https://does.video.coreservices.have.a.wiki.page.for.this
[Code Contribution Checklist]: https://does.video.coreservices.have.a.wiki.page.for.this
