# Provisioner usage

## Overview

Document the expected setup and usage with provisioner


## Provisioner Environment

All netbooted hosts should live under the `netboot` environment. Which should be specified [here](https://provisioner.internal.justin.tv/web/environments). 

## Provisioner Targets
To minimize the number of snowflake targets configured in provisioner, targets should be configured as child nodes of the `netboot` target.

### first level target
Is called `netboot`. This target should only have the following params redefined: `netboot_environment`, `pxelinux_target` and `pxelinux_options`. Any other param should be inherited from the `root` target. Modifying this target will affect every child target, be sure you know what you are doing before changing or adding params.

### second level targets
Second level targets are expected to be the name of the distro with the following params required list below.
* `build_tag`: (required) build tag of the uploaded netboot kernel/initrd/squashfs. this can be found in the jenkins console output. Format: YYYYMMDDHHMMS-GITHASH-JENKINS_BUILD_NUMBER
* `netboot_environment`: (optionial. default: production) Used to set which provisioner s3 reverse proxy to use. All successfully branch build job artifacts are uploaded to the staging provisioner s3 proxy. Values can be either:
  * `production`: artifacts built from master branch
  * `staging`: artifacts built from all other branches
* `netboot_kernel`: version of the kernel to be used associated with the `build_tag`
* `distro_codename`: name of the distro associated with the `build_tag`. Multiple distros can be associated with a single `build_tag`

### third/final level targets
These targets are expected to not exist after [VIDTOOL-2623](https://jira.twitch.com/browse/VIDTOOL-2623) is completed.

These are child targets of the second level targets. If any further params customizations are required, create them on these. Should be named after the target role these are set to.
