#!/bin/bash
set -xe

environment="${1:-staging}"
puppet_branch=${2:-production}

sha=$(git rev-parse --short HEAD)
commit_date=$(git log -1 --pretty='%ad' --date=format:'%Y%m%d%H%M%S')
declare -A s3_url=(
[staging]=s3-reverse-proxy.us-east-2.staging.provisioner.live-video.a2z.com
[production]=s3-reverse-proxy.us-west-2.prod.provisioner.live-video.a2z.com
)
url=${s3_url[$environment]}
read ip < <(dig +short $url)
url_path="jenkins/transcode_ubuntu_image/${commit_date}-${sha}-${BUILD_ID}"

for stats_file in output/*_build_stats ;do
    start=$(date +%s)
    raw_filename=$(basename ${stats_file})
    distro=${raw_filename%%_*}

    for file in output/ubuntu-${distro}-*{initrd,vmlinuz,squashfs}; do
        basename=$(basename $file)
        aws s3 cp --no-progress --only-show-errors $file "s3://provisioner-images-${environment}/${url_path}/${basename}"
        ip_url="http://${ip}/${url_path}/${basename}"
        var_name=$(echo $file|grep -oP "\w+$")
        echo "${var_name}=${ip_url}" >> output/${distro}_artifact_urls
    done

    echo "serverspec_tgz=http://${url}/${url_path}/${distro}_serverspec.tgz" >>output/${distro}_artifact_urls
    echo "puppet_environment=${puppet_branch}" >>output/${distro}_artifact_urls
    tar -czf output/${distro}_serverspec.tgz prepare-boot.sh spec/ Rakefile output/${distro}_artifact_urls
    aws s3 cp --no-progress --only-show-errors output/${distro}_serverspec.tgz "s3://provisioner-images-${environment}/${url_path}/${distro}_serverspec.tgz"

    end=$(date +%s)

    echo "upload_time $((end - start))" >>$stats_file
done
