#!/bin/bash
set -ux

[ -v DISTRO_CODENAME ] || exit 1

environment=${1:-staging}

WAIT_TIME_SECONDS=600
QUEUE_URL="https://us-west-2.queue.amazonaws.com/277437172290/netboot-validator-jobs"
REGION="us-west-2"

SECONDS=$(date +%s)
start=$SECONDS
deadline=$((SECONDS + WAIT_TIME_SECONDS))
. output/${DISTRO_CODENAME}_artifact_urls
run_id="$(basename $(dirname $serverspec_tgz))-${DISTRO_CODENAME}"
message_body=(
    "test_url=$serverspec_tgz"
    "run_id=$run_id"
    "distro_codename=$DISTRO_CODENAME"
    "environment=$environment"
)
aws sqs send-message --queue-url "$QUEUE_URL" --message-body "$(printf "%s\n" "${message_body[@]}")" --region "$REGION"
while ((SECONDS < deadline)); do
    message_json="$(aws sqs receive-message \
        --region "$REGION" \
        --queue-url "${QUEUE_URL::-4}${run_id}" \
        --wait-time-seconds 10)"
    [ -n "$message_json" ] && break
    sleep 10
done
while read line; do
    declare "$line"
done < <(echo "$message_json"|python -c 'import sys, json; print(json.load(sys.stdin)["Messages"][0]["Body"])')
[ -z "${run_url:-}" ] && {
    echo "Error: run_url is unknown"
    return 1
}
while ((SECONDS < deadline)) ; do
    status=$(curl -sf "${run_url}/status") && [ -n "$status" ] && break
    sleep 10
done
echo "shell.log -----------------------------------------------------------------"
curl -s "${run_url}/shell.log"
echo "serial.log ----------------------------------------------------------------"
curl -s "${run_url}/serial.log"
echo "firstboot.log -------------------------------------------------------------"
curl -s "${run_url}/firstboot.log"

echo "test_time $((SECONDS - start))" >> $(dirname $0)/output/${DISTRO_CODENAME}_build_stats

case ${status} in
    "0")
        exit 0
        ;;
    *)
        echo 'Testing failed. See posted logs above.'
        exit "${status}"
        ;;
esac
