#!/bin/bash

set -uex

OUTPUT_DIR=$(dirname $(realpath $0))/output

web_root="http://10.0.2.2:8000"
[ -n "${1:-}" ] && web_root="$1"

ssh_key="$(cat ~/.ssh/*.pub 2>/dev/null || true)"
[ -n "${2:-}" ] && ssh_key="$(cat $2)"

for x in $(cd $OUTPUT_DIR && ls *{initrd,vmlinuz,squashfs}); do
    url=$web_root/$x
    var_name=$(grep -oP "\w+$" <<<$x)
    declare "${var_name}=${url}"
done

hostname="netboot-test-$(openssl rand -hex 3)"

[ -r $OUTPUT_DIR/*_artifact_urls ] && . $OUTPUT_DIR/*_artifact_urls

cat <<POST_BOOT >$OUTPUT_DIR/post-boot
mkdir -p /etc/facter/facts.d/
echo "netboot_validator=true" >/etc/facter/facts.d/netboot_validator.txt
echo "puppet_environment=${puppet_environment:-production}" >/etc/facter/facts.d/puppet_environment.txt
route add -host 169.254.169.254 reject
useradd -m -s /bin/bash toor
sudo_for_toor() {
    while sleep 1; do
        [ -r /etc/sudoers.d/toor ] && continue
        echo "toor ALL=(ALL) NOPASSWD:ALL" >/etc/sudoers.d/toor
        chmod 0440 /etc/sudoers.d/toor
    done
}
sudo_for_toor >/dev/null 2>&1 &
mkdir -p /home/toor/.ssh
echo "$ssh_key" >>/home/toor/.ssh/authorized_keys
POST_BOOT

cat << EOF > $OUTPUT_DIR/boot.ipxe
#!ipxe
kernel $vmlinuz dhcp boot=live fetch=$squashfs nomodeset console=ttyS0,115200n8 live-config.components=hostname,nodm live-config.hostname=$hostname live-config.nottyautologin live-config.debug=true twitch_environment=test-env twitch_role=test-role twitch_team=test-team rootsize=50% BOOTIF=01-\${netX/mac:hexhyp} twitch_hook=$web_root/post-boot puppet_environment=${puppet_environment:-production}
initrd $initrd
boot
EOF
