#!/bin/bash
set -xe

# Delete sources.list
cat << EOF > ${IMAGE_ROOT}/etc/apt/sources.list
# Repos managed by puppet.Info: Computing checksum on file /etc/apt/sources.list
EOF

# Set apt repo inside ${IMAGE_ROOT}
cat << EOF > ${IMAGE_ROOT}/etc/apt/sources.list.d/ubuntu-${UBUNTU_CODENAME}.list
deb [arch=amd64] http://${UBUNTU_REPO_HOSTNAME}/ubuntu ${UBUNTU_CODENAME}-backports main restricted universe multiverse
deb [arch=amd64] http://${UBUNTU_REPO_HOSTNAME}/ubuntu ${UBUNTU_CODENAME} main restricted universe multiverse
deb [arch=amd64] http://${UBUNTU_REPO_HOSTNAME}/ubuntu ${UBUNTU_CODENAME}-security main restricted universe multiverse
deb [arch=amd64] http://${UBUNTU_REPO_HOSTNAME}/ubuntu ${UBUNTU_CODENAME}-updates main restricted universe multiverse
EOF

cat << EOF > ${IMAGE_ROOT}/etc/apt/sources.list.d/twitch.list
# This file is managed by Puppet. DO NOT EDIT.
# twitch
deb [arch=amd64] http://packages.internal.justin.tv/artifactory/ip-${UBUNTU_CODENAME}-twitch/ ${UBUNTU_CODENAME} main
EOF

echo "force-unsafe-io" > ${IMAGE_ROOT}/etc/dpkg/dpkg.cfg.d/force-unsafe-io

cat << EOF > ${IMAGE_ROOT}/etc/apt/apt.conf.d/proxy
Acquire::http { Proxy "http://127.0.0.1:3142"; }
EOF
