#!/bin/bash
set -xe

# Prep / mount tmp directoies. Package installation / post script may/will
# fail with these
find "${IMAGE_ROOT}/dev"     -mindepth 1 -print0 | xargs -0 --no-run-if-empty rm -fr
find "${IMAGE_ROOT}/proc"    -mindepth 1 -print0 | xargs -0 --no-run-if-empty rm -fr
find "${IMAGE_ROOT}/run"     -mindepth 1 -print0 | xargs -0 --no-run-if-empty rm -fr
find "${IMAGE_ROOT}/sys"     -mindepth 1 -print0 | xargs -0 --no-run-if-empty rm -fr
find "${IMAGE_ROOT}/tmp"     -mindepth 1 -print0 | xargs -0 --no-run-if-empty rm -fr
find "${IMAGE_ROOT}/var/tmp" -mindepth 1 -print0 | xargs -0 --no-run-if-empty rm -fr

mount -t devtmpfs                   devtmpfs "${IMAGE_ROOT}/dev"
mount -t devpts   -o gid=5,mode=620 devpts   "${IMAGE_ROOT}/dev/pts"
mount -t proc                       proc     "${IMAGE_ROOT}/proc"
mount -t tmpfs    -o mode=755       tmpfs    "${IMAGE_ROOT}/run"
mount -t sysfs                      sysfs    "${IMAGE_ROOT}/sys"
mount -t tmpfs                      tmpfs    "${IMAGE_ROOT}/tmp"
mount -t tmpfs                      tmpfs    "${IMAGE_ROOT}/var/tmp"
chmod 1777 "${IMAGE_ROOT}/dev/shm"
