#!/bin/bash
set -xe

# remount tmpfs based $IMAGE_ROOT with correct options
mount -o rw,noatime,suid,dev,exec,remount ${IMAGE_ROOT}

# prep and start apt-cache-ng
chown apt-cacher-ng:apt-cacher-ng /var/cache/apt-cacher-ng/
/etc/init.d/apt-cacher-ng start

cd /
# Start building the image in ${IMAGE_ROOT}
if [ -r "${IMAGE_ROOT}.tgz" ]; then
    tar xzf "${IMAGE_ROOT}.tgz"
    cp /etc/resolv.conf ${IMAGE_ROOT}/etc/resolv.conf
else
    debootstrap --arch amd64 --verbose --cache-dir=/debootstrap_cache --include=gnupg,locales --variant=minbase \
        ${UBUNTU_CODENAME} ${IMAGE_ROOT} https://${UBUNTU_REPO_HOSTNAME}/ubuntu
fi
