#!/bin/bash

set -uex -o pipefail

mkdir -p ${IMAGE_ROOT}/etc/facter/facts.d/

# Use tabs before indented heredoc otherwise you get EOF errors
case ${UBUNTU_CODENAME} in
  'bionic')
	cat <<- 'EOF' > ${IMAGE_ROOT}/etc/facter/facts.d/os.json
	{
	  "os": {
	    "name": "Ubuntu",
	    "family": "Debian",
	    "release": {
	      "major": "18.04",
	      "full": "18.04"
	    },
	    "lsb": {
	      "distcodename": "bionic",
	      "distid": "Ubuntu",
	      "distdescription": "Ubuntu 18.04.5 LTS",
	      "distrelease": "18.04",
	      "majdistrelease": "18.04"
	    }
	  }
	}
	EOF
        ;;
  *)
    echo "WARNING: no facter/jenkins workaround added"

esac
