#!/bin/bash
set -xe

mksquashfs ${IMAGE_ROOT} ${IMAGE_ROOT}.squashfs -b 1048576 -comp xz -Xdict-size 100% -regex -e proc/.* -e sys/.* -e run/.* -e var/lib/apt/lists/.*
ls -l ${IMAGE_ROOT}.squashfs ${IMAGE_ROOT}/boot/
echo "squashfs_size $(stat -c %s ${IMAGE_ROOT}.squashfs)" >> /tmp/${UBUNTU_CODENAME}_build_stats
build_start_time=$(stat -c %Y /proc/1)
now=$(date +%s)
echo "build_time $((now - build_start_time))" >> /tmp/${UBUNTU_CODENAME}_build_stats
