#!/bin/bash
set -xe
puppet_package_name=""
case $UBUNTU_CODENAME in
    'bionic')
        puppet_package_name='omnibus-puppet'
        puppet_conf=/opt/omnibus-puppet/etc/puppet.conf
    ;;
    *)
        echo 'puppet_package_name - unsupported ubuntu distribution'
        exit 1
    ;;
esac
chroot ${IMAGE_ROOT} apt-get install --no-install-recommends -y \
  ${puppet_package_name} \
  python-minimal \
  systemd \
  systemd-sysv \
  net-tools \
  i40e-modules-${KERNEL_VERSION}-generic \
  mlnx-en-modules-${KERNEL_VERSION}-generic

agent_disabled_lock="${IMAGE_ROOT}/var/lib/puppet/state/agent_disabled.lock"
[ -f "$agent_disabled_lock" ] && mv "$agent_disabled_lock" "${agent_disabled_lock}.1"

# workaround/overwrite omnibus-puppet's puppet.conf which sets a path that can break openssl
cat << EOF > ${IMAGE_ROOT}/${puppet_conf}
[main]
ca_server = video-puppet-ca.prod.puppet.live-video.a2z.com
logdir = /var/log/puppet
trusted_node_data = true
stringify_facts = false

[agent]
runinterval = 1800
environment = production
server = video-puppet.prod.puppet.live-video.a2z.com
daemonize = false
splay = false
EOF

mkdir -p ${IMAGE_ROOT}/etc/network
cp /etc/hosts ${IMAGE_ROOT}/etc/hosts
