#!/bin/bash
set -xe

. ${IMAGE_ROOT}/usr/local/lib/twitch-init-vars

puppet_ca_server=$(chroot ${IMAGE_ROOT} puppet config print ca_server)
[ -n "$puppet_ca_server" ] && {
    url="https://${puppet_ca_server}:8140/production/certificate_status/$(hostname -f)"
    wget_retry --no-check-certificate --method=PUT --header='Content-Type: text/pson' --body-data='{"desired_state":"revoked"}' "$url"
    wget_retry --no-check-certificate --method=DELETE "$url"
}

agent_disabled_lock="${IMAGE_ROOT}/var/lib/puppet/state/agent_disabled.lock"
[ -f ${agent_disabled_lock}.1 ] && mv ${agent_disabled_lock}.1 ${agent_disabled_lock}

[ "$UBUNTU_CODENAME" == 'bionic' ] && {
    chroot ${IMAGE_ROOT} systemctl disable systemd-resolved
    chmod -x ${IMAGE_ROOT}/lib/systemd/systemd-resolved
    rm -f ${IMAGE_ROOT}/etc/resolv.conf
}

# work around puppet not enabling service in netboot build
chroot ${IMAGE_ROOT} systemctl enable rsyslog

chroot ${IMAGE_ROOT} apt-get purge -y auth-client-config
chroot ${IMAGE_ROOT} apt-get clean

mkdir -p ${IMAGE_ROOT}/var/twitch
chroot ${IMAGE_ROOT} dpkg -l > ${IMAGE_ROOT}/var/twitch/dpkg-l
cp ${IMAGE_ROOT}/var/twitch/dpkg-l /output/${UBUNTU_CODENAME}_dpkg-l

echo "packages_installed $(grep -c ^ii <${IMAGE_ROOT}/var/twitch/dpkg-l)" >> /tmp/${UBUNTU_CODENAME}_build_stats

rm ${IMAGE_ROOT}/etc/{hostname,hosts}
> ${IMAGE_ROOT}/etc/machine-id
rm ${IMAGE_ROOT}/var/lib/dbus/machine-id
rm ${IMAGE_ROOT}/var/log/*.log
rm -rf ${IMAGE_ROOT}/var/lib/puppet/{clientbucket,client_data,client_yaml,preview,ssl,state}/
rm ${IMAGE_ROOT}/etc/apt/sources.list.d/ubuntu-${UBUNTU_CODENAME}.list
rm ${IMAGE_ROOT}/etc/apt/sources.list.d/twitch.list
rm ${IMAGE_ROOT}/etc/dpkg/dpkg.cfg.d/force-unsafe-io
rm ${IMAGE_ROOT}/etc/apt/apt.conf.d/proxy
rm -rf ${IMAGE_ROOT}/root/.cache
rm -rf ${IMAGE_ROOT}/etc/facter/
rm ${IMAGE_ROOT}/etc/ssh/ssh_*key ${IMAGE_ROOT}/etc/ssh/ssh_*key.pub

chroot ${IMAGE_ROOT} update-initramfs -c -k ${KERNEL_VERSION}-generic

# umount everything inside the chroot
# delete any files under mount directories
for mount_point in /proc /run /sys /tmp /var/tmp ; do
    umount "${IMAGE_ROOT}/${mount_point}"
    find "${IMAGE_ROOT}/${mount_point}" -mindepth 1 -print0 | xargs -0 --no-run-if-empty rm -fr
done

ls -l ${IMAGE_ROOT}/var/log/
