#!/bin/bash

set -uex

environment="${1:-production}"
NOW=$(date +%s)

script_dir="$(dirname $0)"

# IMPORTANT! This script assumes, that python3, boto3 and video-pyemf are installed!

for stats_file in $script_dir/../output/*_build_stats ;do
    raw_filename=$(basename ${stats_file})
    distro=${raw_filename%%_*}

    while read metric_name metric_value; do
        $script_dir/emf.py --proto logs --metric "$metric_name" --value "$metric_value" --distro "$distro" --environment "$environment" --now "$NOW"
    done  < $stats_file
done
