#!/bin/bash

set -uex -o pipefail

BUILD_DATE=$(date -Iminutes)
BUILD_ID=${BUILD_ID:-unknown}
GIT_COMMIT=${GIT_COMMIT:-unknown}
GIT_COMMIT=${GIT_COMMIT%-dirty}

# Add version information to the image
cat << EOF | tee ${IMAGE_ROOT}/etc/twitch-image-version
{
  "git_repository": "video-coreservices/transcode_ubuntu_image",
  "git_commit": "$GIT_COMMIT",
  "build_date": "$BUILD_DATE",
  "build_tag": "$BUILD_ID"
}
EOF
