require 'spec_helper'

describe command('locale') do
  its(:stdout) { should match /en_US\.UTF-8/ }
end

describe command('hostname -f') do
  its(:stdout) { should match /\.(justin\.tv|a2z\.com)/ }
end

describe host('proxy.internal.justin.tv') do
  it { should be_resolvable }
end

describe file('/etc/twitch-image-version') do
  it { should be_file }
  its(:content_as_json) { should_not include( 'git_commit' => 'unknown' ) }
  its(:content_as_json) { should_not include( 'build_tag' => 'unknown' ) }
end

describe service('systemd-resolved') do
  it { should_not be_enabled }
  it { should_not be_running }
end
