require 'spec_helper'

%w( libpam-sss libnss-sss ca-certificates sssd ).each do |pkg|

  describe package(pkg) do
    it { should be_installed }
  end

end

describe file('/etc/sssd/sssd.conf') do
  it { should be_file }
  its(:content) { should match /ldap_uri = ldaps:\/\/ldap-ro\.internal\.justin\.tv/ }
end

describe file('/etc/auth-client-config/profile.d/twitch_sss') do
  it { should be_file }
  its(:content) { should match /twitch_sss/ }
end
