require 'spec_helper'

%w( twitch-inventoryagent).each do |pkg|

  describe package(pkg) do
    it { should be_installed }
  end

end

expected_packages = {
  "16.04" => 309,
  "18.04" => 310
}

describe command('grep -c ^ii /var/twitch/dpkg-l') do
  its(:stdout) { should be_equal_to expected_packages[os[:release]] }
end

# twitch-inventoryagent installed on firstboot. Not during build
describe file('/var/twitch/dpkg-l') do
  its(:content) { should_not match /twitch-inventoryagent/ }
end
