require 'spec_helper'

describe package('rsyslog') do
  it { should be_installed }
end

describe service('rsyslog') do
  it { should be_enabled }
  it { should be_running }
end

describe file('/var/log') do
  it { should be_directory }
  it { should be_mode 775 }
  it { should be_owned_by 'root' }
  it { should be_grouped_into 'syslog' }
end
