require 'spec_helper'

describe service('ssh') do
  it { should be_enabled }
  it { should be_running }
end

describe file('/etc/ssh/sshd_config') do
  it { should be_file }
  its(:content) { should match /Port\s+22/ }
end

describe port(22) do
  it { should be_listening }
end

Dir.glob("/lib/live/mount/rootfs/*/etc/ssh/ssh_*_key").each do |ssh_key|
  describe file(ssh_key) do
    it { should_not be_file }
  end

  describe file("#{ssh_key}.pub") do
    it { should_not be_file }
  end
end
