#!/bin/bash

# based on https://github.com/Intel-Media-SDK/MediaSDK/wiki/Build-Media-SDK-on-Ubuntu
# Reference https://software.intel.com/en-us/articles/build-and-debug-open-source-media-stack
# Reference https://github.com/Intel-Media-SDK/MediaSDK/releases/tag/intel-mediasdk-20.1.0

set -e -u -x

SUDO=$(which sudo || true)
JOBS=$(($(nproc) / 2 ))

KERNEL_VER="4.14"
LIBDRM_VER="2.4.84"
LIBVA_VER="2.7.0"
LIVVA_UTILS_VER="2.7.1"
GMMLIB_VER="20.1.1"
DRIVER_VER="20.1.1"
SDK_VER="20.1.0"
OPENCL_VER="20.10.16087" # https://github.com/intel/compute-runtime/releases/tag/20.10.16087

# OLD CentOS pre-requisites
#   yum $YUM_ARGS install uuid-devel openssl-devel curl wget gperf bzip2-devel zlib-devel libicu-devel openmpi-devel python-devel python-setuptools python-dateutil
#   yum -y -t "$@" install kernel-headers kernel-devel bc wget bison ncurses-devel hmaccalc zlib-devel binutils-devel elfutils-libelf-devel rpm-build redhat-rpm-config asciidoc hmaccalc perl-ExtUtils-Embed pesign xmlto audit-libs-devel binutils-devel elfutils-devel elfutils-libelf-devel newt-devel numactl-devel pciutils-devel python-devel zlib-devel
# CentOS LibVA with just DRM
#   cd /opt/intel/mediasdk/opensource/libva/${LIBVA_VERSION}-*/
#   tar -xjvf libva*
#   cd libva-*
#   ./configure --enable-x11=no --enable-glx=no --enable-egl=no --enable-wayland=no --disable-static --prefix=/usr --libdir=/usr/lib64/
#   make clean
#   make
#   cd va/.libs/
#   mkdir -p "$OUTPUT_DIR"
#   tar -czvf "$OUTPUT_DIR/libva_${LIBVA_VERSION}.tar.gz" libva*.so*
# CentOS Media Server Studio packages
#   libdrm-$LIBDRM_VER-$BUILD_ID.el7.centos.x86_64.rpm \
#   libdrm-devel-$LIBDRM_VER-$BUILD_ID.el7.centos.x86_64.rpm \
#   drm-utils-$LIBDRM_VER-$BUILD_ID.el7.centos.x86_64.rpm \
#   libva-$LIBVA_VER-$BUILD_ID.el7.centos.x86_64.rpm \
#   libva-devel-$LIBVA_VER-$BUILD_ID.el7.centos.x86_64.rpm \
#   intel-linux-media-$MILESTONE_VER-$BUILD_ID.el7.centos.x86_64.rpm \
#   intel-linux-media-devel-$MILESTONE_VER-$BUILD_ID.el7.centos.x86_64.rpm \
#   intel-opencl-*.x86_64.rpm || {
# CentOS MediaSDK install
#   SDK_VER = "intel-v69021"
#   BUILD_ID=69021
#   MILESTONE_VER=16.8
#   LIBDRM_VER=2.4.74
#   LIBVA_VER=2.0.1.pre1
#   git_clone "video/intel_media_sdk" $VERSION
# OLD CentOS pre-requisites

### Install build pre-requisites
apt-get update

apt-get -y install libdrm-dev automake autoconf libtool git pkg-config python-pip && pip install cmake
# apt-get install libffi libffi-dev expat expat-dev # Wayland support
# apt-get install libx11-dev xorg xorg-dev openbox # X11 support
# apt-get install libgl1-mesa-dev libgl1-mesa-glx # GLX support
apt-get -y install libssl-dev dh-autoreconf libpciaccess-dev # Required for Intel media drivers

# TODO: Build/Install Intel OpenCL packages ???

### Build and install libVA
cd /tmp && $SUDO rm -rf libva
git clone https://github.com/intel/libva.git && cd libva && git checkout tags/$LIBVA_VER
./autogen.sh --prefix=/opt/quicksync/libva --libdir=/opt/quicksync/libva/lib
make -j $JOBS && $SUDO make install
export PKG_CONFIG_PATH=${PKG_CONFIG_PATH-default}:/opt/quicksync/libva/lib/pkgconfig    # NOTE: Intel media driver cmake fails if this isn't set
export LD_LIBRARY_PATH=${LD_LIBRARY_PATH-default}:/opt/quicksync/libva/lib

# LibVA-Utils - useful for running vainfo to validate install
# cd /tmp && git clone https://github.com/intel/libva-utils.git && cd libva-utils && git checkout tags/$LIVVA_UTILS_VER
#./autogen.sh --prefix=/opt/quicksync/libva-utils --libdir=/opt/quicksync/libva-utils/lib && make && make install

### Build and install Intel media drivers
cd /tmp && $SUDO rm -rf gmmlib
git clone https://github.com/intel/gmmlib.git && cd gmmlib && git checkout tags/intel-gmmlib-$GMMLIB_VER
mkdir build && cd build
cmake -DCMAKE_INSTALL_PREFIX:PATH=/opt/quicksync/gmmlib -DCMAKE_BUILD_TYPE=Release -DARCH=64 ..
make -j $JOBS && $SUDO make install
export PKG_CONFIG_PATH=$PKG_CONFIG_PATH:/opt/quicksync/gmmlib/lib/pkgconfig             # NOTE: Intel media driver cmake fails if this isn't set

cd /tmp && $SUDO rm -rf media-driver
git clone https://github.com/intel/media-driver.git && cd media-driver && git checkout tags/intel-media-$DRIVER_VER
cd /tmp && mkdir -p driver_build && cd driver_build
cmake ../media-driver \
-DCMAKE_INSTALL_PREFIX=/opt/quicksync/media-driver \
-DCMAKE_INSTALL_LIBDIR=/opt/quicksync/media-driver/lib \
-DLIBVA_DRIVERS_PATH=/opt/quicksync/media-driver/lib/dri
make -j $JOBS && $SUDO make install
export LIBVA_DRIVER_NAME=iHD
export LIBVA_DRIVERS_PATH=/opt/quicksync/media-driver/lib/dri
# vainfo

### Build and install Intel Media SDK
cd /tmp && $SUDO rm -rf MediaSDK
git clone https://github.com/Intel-Media-SDK/MediaSDK && cd MediaSDK && git checkout tags/intel-mediasdk-$SDK_VER
mkdir build && cd build
export MFX_Home=/opt/quicksync/mediasdk
cmake -DCMAKE_INSTALL_PREFIX:PATH=/opt/quicksync/mediasdk ..
make -j $JOBS && $SUDO make install
export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:/opt/quicksync/mediasdk/lib

### Build twitch-quicksync debian package that includes all of the above
build_package() {
    cd /tmp
    mkdir -p "$pkg_name/DEBIAN"

cat << CONTROL > "$pkg_name/DEBIAN/control"
Package: $pkg_name
Version: $pkg_version
Architecture: amd64
Maintainer: video-coreservices@twitch.tv
Description: $pkg_description
Depends: libdrm2, libpciaccess0
CONTROL
    [ -n "${pkg_depends:-}" ] && echo "Depends: $pkg_depends" >> "$pkg_name/DEBIAN/control"
    cp -r --parents "$pkg_path" "$pkg_name"
    dpkg-deb --build "${pkg_name}" packages/
}

rm -rf /usr/local/lib/python2.7

BUILD_NUMBER=5

pkg_name="twitch-quicksync"
pkg_version="${SDK_VER}-${BUILD_NUMBER}"
pkg_description="Twitch build of the Intel Media SDK and prerequisites"
pkg_path="/opt/quicksync/"
build_package

# TODO:
#       Add additional validation/test scripts to Jenkins build/deployment ???
# TODO: Reach out to #video-coreservices slack channel for help with debian package building and Jenkins
# TODO: Reach out to dev-infra for help with Jenkins, github, artifactery
#       Add unit tests to Jenkins build
#       
