# unbound

This backports the latest `unbound` packages from `eoan` onto `xenial` and `bionic`. These includes supporting packages that's built with unbound such as `unbound-anchor` and `libunbound`.

## Manual building

Packages will be available under the respective distro directory (i.e. `xenial` and/or `bionic` folder).

```
# Building xenial packages
$ make xenial

# Example xenial builds
$ tree xenial/
xenial/
├── libunbound-dev_1.9.0-2ubuntu1.twitch1_amd64.deb
├── libunbound8_1.9.0-2ubuntu1.twitch1_amd64.deb
├── python-unbound_1.9.0-2ubuntu1.twitch1_amd64.deb
├── python3-unbound_1.9.0-2ubuntu1.twitch1_amd64.deb
├── unbound-anchor_1.9.0-2ubuntu1.twitch1_amd64.deb
├── unbound-host_1.9.0-2ubuntu1.twitch1_amd64.deb
└── unbound_1.9.0-2ubuntu1.twitch1_amd64.deb

# Building bionic packages
$ make bionic
```

# Automated building

Packages can be manually built and uploaded to artifactory via [`video-coreservices/package-builder`](https://jenkins.internal.justin.tv/job/video-coreservices/job/package-builder).

## Triggered building and deploying to artifactory

New packages are automatically built when changes are pushed into this repository. Packages are automatically uploaded to `testing` repository for branch builts. New packages are automatically built and uploaded into `production` artifactory repository when changes are merged into `master`.

Package building and automated uploading to artifactory are features that is built within `video-coreservices/package-builder` and is triggered via the following jenkins pipeline: [`video-coreservices/unbound`](https://jenkins.internal.justin.tv/job/video-coreservices/job/unbound).

## Known Issues

* Due to [IPDEV-1113](https://jira.twitch.com/browse/IPDEV-1113), only `xenial` builds are enabled.
