# video-cloudwatch-agent
Video instance install of Cloudwatch Agent

Automatically configures itself with additional metric dimensions for role, environment and pop via facter at install.

The config template lives in `fpm_source/opt/twitch/video-cloudwatch-agent/etc/amazon-cloudwatch-agent.json.tmpl`

Tokens `default_region`, `role`, `environment` and `pop` are replaced by `factja` at package install time.

Note that 'testing' targets generally only exist for debian packages.


## jenkins jobs
![build status](https://jenkins-og.xarth.tv/view/all/job/video-cloudwatch-package-build/badge/icon?style=plastic) -
[video-cloudwatch-package-build](https://jenkins-og.xarth.tv/job/video-cloudwatch-package-build/)

Builds the video-cloudwatch-agent package. Automatically triggers off commits to 'master'.
Automatically triggers a deploy to the 'testing' target.

---

![build status](https://jenkins-og.xarth.tv/view/all/job/video-cloudwatch-package-deploy-testing/badge/icon?style=plastic) -
[video-cloudwatch-package-deploy-testing](https://jenkins-og.xarth.tv/job/video-cloudwatch-package-deploy-testing/)

Uploads built package to the 'testing' packages.internal repo. Automatically triggered on commits to master after build.

---

![build status](https://jenkins-og.xarth.tv/view/all/job/video-cloudwatch-package-deploy-production/badge/icon?style=plastic) -
[video-cloudwatch-package-deploy-production](https://jenkins-og.xarth.tv/job/video-cloudwatch-package-deploy-production/)

Uploads built package to the 'production' packages.internal repo. Manually triggered from [Skadi](https://clean-deploy.internal.justin.tv/#/video-coreservices/video-cloudwatch-agent).

---

![build status](https://jenkins-og.xarth.tv/view/all/job/video-cloudwatch-package-fetch-testing/badge/icon?style=plastic) -
[video-cloudwatch-package-fetch-testing](https://jenkins-og.xarth.tv/job/video-cloudwatch-package-fetch-testing/)

Fetches latest amazon-cloudwatch-agent package and uploads it to the 'testing' packages.internal repo. Manually triggered from Jenkins.

---

![build status](https://jenkins-og.xarth.tv/view/all/job/video-cloudwatch-package-fetch-production/badge/icon?style=plastic) -
[video-cloudwatch-package-fetch-production](https://jenkins-og.xarth.tv/job/video-cloudwatch-package-fetch-production/)

Fetches latest amazon-cloudwatch-agent package and uploads it to the 'production' packages.internal repo. Manually triggered from Jenkins.

