job {
    name 'video-cloudwatch-package-build'
    description("build video-cloudwatch-agent package")
    using 'TEMPLATE-autobuild'

    wrappers {
        credentialsBinding {
            string('GITHUB_ACCESS_TOKEN', 'devtools-deployment-github-api-token')
            file('AWS_CONFIG_FILE', 'aws_config')
            file('ARTI_CONFIG_FILE', 'dta_arti_creds')
            string 'dta_tools_deploy', 'dta_tools_deploy'
        }
    }

    scm {
        git {
            remote {
                github 'video-coreservices/video-cloudwatch-agent', 'ssh', 'git.xarth.tv'
                credentials 'git-aws-read-key'
            }
            clean true
            branches 'origin/*'
        }
    }

    steps {
        shell """
        manta -v -E ITERATION=\${BUILD_NUMBER}
        cp pkg/video-cloudwatch-agent_*.deb pkg/video-cloudwatch-agent.deb
        cp pkg/video-cloudwatch-agent-*.rpm pkg/video-cloudwatch-agent.rpm
        """
        saveDeployArtifact 'video-coreservices/video-cloudwatch-agent', 'pkg'
    }

    publishers {
        flexiblePublish {
            conditionalAction {
                condition {
                    status('SUCCESS', 'SUCCESS')
                }
                steps {
                    shell './auto-deploy.sh -b master -e testing -c \"$GIT_COMMIT\" -t \"$GITHUB_ACCESS_TOKEN\"'
                }
            }
        }
    }
}

job {
    name 'video-cloudwatch-package-deploy-testing'
    description("upload video-cloudwatch-agent package to testing repo")
    using 'TEMPLATE-deploy'

    wrappers {
        credentialsBinding {
            file('AWS_CONFIG_FILE', 'aws_config')
            file('ARTI_CONFIG_FILE', 'dta_arti_creds')
            string 'dta_tools_deploy', 'dta_tools_deploy'
        }
    }

    steps {
        downloadDeployArtifact 'video-coreservices/video-cloudwatch-agent'
        uploadDeb "-p testing video-cloudwatch-agent.deb", ['xenial', 'bionic']
    }
}

job {
    name 'video-cloudwatch-package-deploy-production'
    description("upload video-cloudwatch-agent package to prod repo")
    using 'TEMPLATE-deploy'

    wrappers {
        credentialsBinding {
            file('AWS_CONFIG_FILE', 'aws_config')
            file('ARTI_CONFIG_FILE', 'dta_arti_creds')
            string 'dta_tools_deploy', 'dta_tools_deploy'
        }
    }

    steps {
        downloadDeployArtifact 'video-coreservices/video-cloudwatch-agent'
        uploadDeb "video-cloudwatch-agent.deb", ['xenial', 'bionic']
        uploadRPM "video-cloudwatch-agent.rpm", 'centos7'
    }
}

job {
    name 'video-cloudwatch-package-fetch-testing'
    description("fetch amazon-cloudwatch-agent package and upload to packages.internal testing repo")

    wrappers {
        credentialsBinding {
            file('AWS_CONFIG_FILE', 'aws_config')
            file('ARTI_CONFIG_FILE', 'dta_arti_creds')
            string 'dta_tools_deploy', 'dta_tools_deploy'
        }
    }

    steps {
        shell """
        curl -O --retry 5 https://s3.amazonaws.com/amazoncloudwatch-agent/debian/amd64/latest/amazon-cloudwatch-agent.deb
        """
        uploadDeb "-p testing amazon-cloudwatch-agent.deb", ['xenial', 'bionic']
    }
}

job {
    name 'video-cloudwatch-package-fetch-production'
    description("fetch amazon-cloudwatch-agent package and upload to packages.internal testing repo")

    wrappers {
        credentialsBinding {
            file('AWS_CONFIG_FILE', 'aws_config')
            file('ARTI_CONFIG_FILE', 'dta_arti_creds')
            string 'dta_tools_deploy', 'dta_tools_deploy'
        }
    }

    steps {
        shell """
        curl -O --retry 5 https://s3.amazonaws.com/amazoncloudwatch-agent/debian/amd64/latest/amazon-cloudwatch-agent.deb
        curl -O --retry 5 https://s3.amazonaws.com/amazoncloudwatch-agent/centos/amd64/latest/amazon-cloudwatch-agent.rpm
        """
        uploadDeb "amazon-cloudwatch-agent.deb", ['xenial', 'bionic']
        uploadRPM "amazon-cloudwatch-agent.rpm", 'centos7'
    }
}

