# twitch-glitch-bot

Glitch Slack bot used at Twitch, written in Go, packaged for debian and redhat.
The tests and binary work great on a Mac or in Vagrant.

In addition to the main package that glues everything together, the bot
comes with three additional packages and five or more handlers (also packages).

The Jira, Slack and PagerDuty packages provide interfaces and come with counterfeit
packages that should be used in tests. They allow you to mock and inspect the
methods in these interfaces. Uses [counterfeiter](https://github.com/maxbrunsfeld/counterfeiter)
to created mock methods so if you update any of these you will need to install / run
counterfeiter again to regenerate the mocks, for example:

Installing counterfeiter
```
go get github.com/maxbrunsfeld/counterfeiter
go install github.com/maxbrunsfeld/counterfeiter
```

Example mock generation
```
counterfeiter pkg/pagerduty/config.go Client
```
## Internal Packages

There are several helper packages included in this app. They provide interfaces,
methods and types to get new handlers up and running.

### Slack

The `slack` package is (or generally should be) plugged into every handler. The
interface it provides allows sending messages, getting users & channels and
responding to configured commands. All handlers must return an interface that
satisfies the `slack.Handler` type. **The slack interface will grow over time.**

The slack package utilizes this library: [github.com/nlopes/slack](https://github.com/nlopes/slack/)

### Jira

The `jira` package is currently plugged into the `tickets` and `incidents`
handlers. It provides an interface to open tickets, add comments and close them.

The Jira package utilizes this library: [github.com/andygrunwald/go-jira](https://github.com/andygrunwald/go-jira/)

### Exp

The `exp` package provides a handful of methods and types for working with
`expvar` data. Glitch uses `expvar` heavily to store data and provide an easy
debugging interface.

## Handlers

The handlers are packages that provide a `slack.Handler` interface. With it,
they are able to respond to commands and provide run time data to other parts
of the application.

The `exports` handler is a good example to copy/paste if you're looking to
extend functionality. Please include tests with any pull requests.

### exports

The `exports` handler simply replies to `!expvar` with the expvar exported data.

### incidents

The `incidents` handler is one of the reasons Glitch exists. This handler
provides `!open`, `!close` and `!move` commands to open Jira INC tickets.
Opening an incident ticket begins logging in the channel it was opened. Moving
an incident changes the logging channel. Closing an incident stops logging, attaches
the log file to the ticket, and marks the incident Closed in Jira.

### oncall

Provides a `!oncall` command to list the pager duty on-call contacts.

Utilizes the official PagerDuty Go Library: [github.com/PagerDuty/go-pagerduty](https://github.com/PagerDuty/go-pagerduty/)

### tickets

Allows slack users to send `!ticket <project> <description>` to open a ticket
right from a slack channel. Interfaces with Jira.

### chat

This handler provides slack and chat controls for the bot. This allows you to
make the bot join and leave channels, conversations, and more!

# Contributing

... by all means. Please include tests.

# License

None, silly. This is private intellectual property.
