glitch(1) -- Twitch General Purpose Slack Bot
===

## SYNOPSIS

`glitch [-c <config file>] [-p <pid file>] [-b <bot name>] [--debug] [--version]`

## DESCRIPTION

This application runs as a daemon, listening for incoming slack commands.
Specific handlers, such as `!oncall`, are baked-in and available for use. This
bot allows users on Slack to retrieve pager duty on-call information, create
Jira tasks, and record channel activity during incidents.

## OPTIONS

`glitch --config=/etc/glitch/glitch.conf -p /run/glitch/pid -l 127.0.0.1:53782`


    -c, --config <file path>
        The path to the main Glitch config file.
        Default: /etc/glitch/glitch.conf

    -p, --pid <file path>
        Glitch will write its pid to this file. If Glitch finds another pid in
        the file, and it's "alive" the application will exit with return code 3.
        If the PID file cannot be written the application exits with code 2.
        Default: /run/glitch/pid

    -d, --debug
        Enable verbose output.

    -b, --botname <bot name>
        Sets the running name of the bot. Used to set the expvar key among
        other things. Default: Glitch

    -v, --version
        Display version and exit.

    -h, --help
        Display usage and exit.

## CONFIGURATION

Explain the config file format here.

## AUTHOR

* Twitch Core Systems <systems@twitch.tv>

## LOCATION

* https://git.xarth.tv/systems/twitch-glitch-bot
