package main

import (
	// standard
	"expvar"
	"net/http"
	"os"

	// external
	"github.com/gorilla/mux"

	// local
	"code.justin.tv/video-coreservices/video-coreservices-slack-bot/handlers/incidents"
	"code.justin.tv/video-coreservices/video-coreservices-slack-bot/handlers/oncall"
	"code.justin.tv/video-coreservices/video-coreservices-slack-bot/handlers/tickets"
        "code.justin.tv/video-coreservices/video-coreservices-slack-bot/handlers/vidcs"
	"code.justin.tv/video-coreservices/video-coreservices-slack-bot/pkg/jira"
	"code.justin.tv/video-coreservices/video-coreservices-slack-bot/pkg/slack"
)

const (
	defaultPidFilePath = "/run/glitch/pid"
	defaultConfigPath  = "/etc/glitch/glitch.conf"
)

var (
	// BotName is the name of this bot. move this to a config file?
	BotName = "vidcs"
	// Version is injected at build time.
	Version = "development"
	// testRun is used to prevent os.Exit() in unit tests.
	testRun bool
	// Tests change these to pull in clients with mock data calls.
	getJiraClient  = jira.GetClient
	getSlackClient = slack.GetClient
)

// Config defines the data provided by the config file.
// Add new handler configs here.
type Config struct {
	BindAddr   string            `toml:"http_address"`
	Slack      *slack.Config     `toml:"slack"`
	Jira       *jira.Config      `toml:"jira"`
	Incidents  *incidents.Config `toml:"incidents"`
	OnCall     *oncall.Config    `toml:"oncall"`
	Tickets    *tickets.Config   `toml:"tickets"`
        Vidcs      *vidcs.Config     `toml:"vidcs"`
	pidFile    string
	configFile string
}

// Contains our expvar exports.
type exportData struct {
	*expvar.Map
	version    expvar.String
	configFile expvar.String
	pidFile    expvar.String
	bindAddr   expvar.String
	reloads    expvar.Int
	httpVisits expvar.Int
}

// Glitch contains our long-running application data.
type Glitch struct {
	Config      *Config
	SlackClient slack.Client
	HTTPServer  *http.Server
	Handlers    []slack.Handler
	Router      *mux.Router
	SigKILLChan chan os.Signal
	SigHUPChan  chan os.Signal
	Export      exportData
}
