#!/bin/bash

OUTPUT=$1

# This is run by jenkins.groovy in a docker image w/ ronn installed.
for f in cmd/*/README.md;do
    # Strtip off cmd/ then strip off README to get the man-file name.
    PKGNOCMD="${f#cmd/}"
    PKG="${PKGNOCMD%/README.md}"
    echo "Creating Man Page: ${f} -> ${OUTPUT}${PKG}.1.gz"
    ronn < "$f" | gzip -9 > "${OUTPUT}${PKG}.1.gz"
done
