#!/bin/bash
# This script is run from Manta; it builds package "folders" for Glitch.
# Jenkins turns the folders into packages for their corresponding OS.

set -e

BUILD="/go/src/code.justin.tv/video-coreservices/video-coreservices-slack-bot/build"
OUTPUT="/go/src/code.justin.tv/video-coreservices/video-coreservices-slack-bot/output"
INSTALL="${BUILD}/usr/bin/"
VERSION="$(head -n1 fpm_scripts/VERSION)"
# List of files changed in this branch.
CHANGES=$(git diff --diff-filter=M origin/master... --name-only)
# Strip origin/ from the provided branch name.
BRANCH=$(echo "$GIT_BRANCH" | cut -d/ -f2)
# Add first 7 characters of git sha to the version.
[ "$GIT_COMMIT" = "" ] || VERSION="${VERSION}-$(echo "${GIT_COMMIT}" | head -c7)"
# Add the branch name to the version if not master.
[ "$BRANCH" = "master" ] || [ "$BRANCH" = "" ] || VERSION="${VERSION}-${BRANCH}"

echo "Setting Package Version To: ${VERSION}"

# if this is a master branch, set the iteration to 1.
# Otherwise jenkins sets it to the build number.
[ "$BRANCH" = "master" ] && echo 1 > fpm_scripts/ITERATION

# Clean and re-create our work space.
rm -rf "${BUILD}" "${OUTPUT}"
mkdir -p "${OUTPUT}" "${INSTALL}" "${BUILD}/var/log/glitch" "${BUILD}/var/lib/glitch"
mkdir -p "${BUILD}/lib/systemd/system" "${BUILD}/etc/glitch"
cp example.glitch.conf "${BUILD}/etc/glitch/glitch.conf"

echo "Testing and Building Go Apps for linux."
make testcov

# Install Manual Pages (built by another step in jenkins.groovy)
mkdir -p "${BUILD}/usr/share/man/man1"
cp manpages/*.1.gz "${BUILD}/usr/share/man/man1/"

GOOS=linux GOBIN=${INSTALL} VERSION=${VERSION} make install

echo "Creating Debian Folder to be Packaged."
mkdir -p "${BUILD}/lib/systemd/system" "${BUILD}/etc/default"
cp fpm_scripts/debian.unit "${BUILD}/lib/systemd/system/glitch.service"
echo "CONFIG_FILE=/etc/glitch/glitch.conf" > "${BUILD}/etc/default/glitch"
cp -r "${BUILD}" "${OUTPUT}/debian"

echo "Creating RedHat Folder to be Packaged."
mv "${BUILD}/etc/default" "${BUILD}/etc/sysconfig"
cp fpm_scripts/redhat.unit "${BUILD}/lib/systemd/system/glitch.service"
cp -r "${BUILD}" "${OUTPUT}/redhat"

cp test_coverage.* "${OUTPUT}"

echo "Done Building Package Contents."
