package incidents

import (
	// standard
	"expvar"
	"sync"

	// local
	"code.justin.tv/video-coreservices/video-coreservices-slack-bot/pkg/jira"
	"code.justin.tv/video-coreservices/video-coreservices-slack-bot/pkg/slack"
)

const (
	defaultProject      = "INC"
	defaultIssueType    = "Incident"
	defaultTransitionID = "11" // ("11" is `Fixed` in the INC project)
	fileRegex           = `^([^-]+)-([^\.]+)\.log$`
	numberRegex         = `^[0-9]+$`
	postmortemTemplate  = "https://docs.google.com/document/d/1hGgAdzyLGGAqARtNteAJheE7LW3fNpKzdb7hR3j4BQQ/edit"
)

// Config defines the data provided form Glitch config file.
type Config struct {
	ChatLogDir   string
	ProjectKey   string `toml:"project_key"`
	IssueType    string `toml:"issue_type"`
	TransitionID string `toml:"transition_id"`
}

type handler struct {
	cfg             *Config
	jiraClient      jira.Client
	slackClient     slack.Client
	export          exportData
	stopChan        chan bool
	trackedChannels []*trackedChannel
	sync.Mutex
}

type exportData struct {
	expvar.Map
	osOpenErrors     expvar.Int
	osRemoveErrors   expvar.Int
	fileCloseErrors  expvar.Int
	attachFileErrors expvar.Int
}

type trackedChannel struct {
	channelID   string
	incidentKey string
	messages    chan (string)
	close       chan (struct{})
}
