package incidents

import (
	// standard
	"testing"

	// external
	"github.com/stretchr/testify/assert"

	// local
	"code.justin.tv/video-coreservices/video-coreservices-slack-bot/pkg/jira/jirafakes"
	"code.justin.tv/video-coreservices/video-coreservices-slack-bot/pkg/slack"
	"code.justin.tv/video-coreservices/video-coreservices-slack-bot/pkg/slack/slackfakes"
)

// This only does a partial cover because we have no slack connection in tests.
func TestIsMatch(t *testing.T) {
	t.Parallel()
	a := assert.New(t)

	// Mock data
	config := &Config{ChatLogDir: "/tmp/incidents"}
	slackClient := new(slackfakes.FakeClient)
	jiraClient := new(jirafakes.FakeClient)
	handler := Init(config, slackClient, jiraClient)
	a.NotNil(handler.Export())
	msg := slack.Message{}
	// Do the test!
	msg.Data.Text = "!open"
	a.True(handler.IsMatch(msg), "handler must return true")
	msg.Data.Text = "!close"
	a.True(handler.IsMatch(msg), "handler must return true")
	msg.Data.Text = "!move"
	a.True(handler.IsMatch(msg), "handler must return true")
	msg.Data.Text = "!notforus"
	a.False(handler.IsMatch(msg), "handler must return false")
	a.Nil(handler.Stop())
}
