package incidents

import (
	// standard
	"testing"

	// external
	"github.com/stretchr/testify/assert"
)

func TestDeleteTrackedChannel(t *testing.T) {
	t.Parallel()
	a := assert.New(t)

	handler := &handler{
		trackedChannels: make([]*trackedChannel, 0),
	}

	handler.trackedChannels = append(handler.trackedChannels, &trackedChannel{
		channelID:   "ABC",
		incidentKey: "INC-123",
		close:       make(chan struct{}),
		messages:    make(chan string, 10),
	})
	handler.trackedChannels = append(handler.trackedChannels, &trackedChannel{
		channelID:   "DEF",
		incidentKey: "INC-456",
		close:       make(chan struct{}),
		messages:    make(chan string, 10),
	})

	handler.deleteTrackedChannel("INC-456")

	a.Equal(1, len(handler.trackedChannels))
	a.Equal("INC-123", handler.trackedChannels[0].incidentKey)

	// testing deleting something that isn't there
	handler.deleteTrackedChannel("INC-1337")

	a.Equal(1, len(handler.trackedChannels))
}
