package tickets

import (
	// standard
	"expvar"

	// local
	"code.justin.tv/video-coreservices/video-coreservices-slack-bot/pkg/jira"
	"code.justin.tv/video-coreservices/video-coreservices-slack-bot/pkg/slack"
)

const (
	commandRegex     = `^!ticket\s?(.*)`
	keySuppliedRegex = `([^\s]+)\s(.+)`
)

// Config is the data loaded from the Glitch config file.
type Config struct {
	Channels map[string][]channelConfig `toml:"channels"`
}

type channelConfig struct {
	ProjectKey string `toml:"project_key"`
	IssueType  string `toml:"issue_type"`
}

type handler struct {
	cfg         *Config
	slackClient slack.Client
	jiraClient  jira.Client
	export      exportData
}

type exportData struct {
	expvar.Map
}
