package vidcs

import (
	// standard
	"expvar"
	"log"

	//	"regexp"
	"strings"
	// local
	//  "code.justin.tv/video-coreservices/video-coreservices-slack-bot/pkg/exp"
	//	"code.justin.tv/video-coreservices/video-coreservices-slack-bot/pkg/jira"
	"code.justin.tv/video-coreservices/video-coreservices-slack-bot/pkg/slack"
)

// Init is called during setup of all commands and is used to register the correct callbacks by returning a common.Command
//func Init(cfg *Config, slackClient slack.Client, jiraClient jira.Client) slack.Handler {
func Init(cfg *Config, slackClient slack.Client) slack.Handler {
	handler := &handler{
		cfg:         cfg,
		slackClient: slackClient,
		//		jiraClient:  jiraClient,
	}
	handler.export.Init()
	handler.export.Set("call_counter", &handler.export.callCounter)
	handler.export.Set("error_counter", &handler.export.errCounter)
	//	log.Println("Tickets Handler Loaded!", len(config.Channels), "channels configured. Commands: !ticket")
	log.Println("Vidcs Handler loaded!")
	return handler
}

func stringInSlice(a string, list []string) bool {
	for _, b := range list {
		if b == a {
			return true
		}
	}
	return false
}

func (h *handler) IsMatch(msg slack.Message) bool {
	log.Print("Something happened")
	//	log.Print("Team members:", h.cfg.TeamMembers)
	//	log.Print(h.slackClient.GetEntityName(msg.Data.User))
	//	TeamMembersTest := strings.Split(h.cfg.TeamMembers, " ")
	//	log.Print(TeamMembersTest)
	//return regexp.MustCompile(commandRegex).MatchString(msg.Data.Text)
	return true
}

func (h *handler) Name() string {
	return "vidcs"
}

//func welcome_old(h *handler, msg slack.Message) {
//	h.slackClient.SendReply(msg, h.cfg.ChannelJoinGreeting)
//}

func welcome(h *handler, msg slack.Message) {
	ChannelJoinGreetingBeginning := h.cfg.ChannelJoinGreetingBeginning
	ChannelJoinGreetingEnd := h.cfg.ChannelJoinGreetingEnd
	//ChannelJoinGreetingBeginning = ChannelJoinGreetingBeginning + " " + msg.Data.User + " " + h.slackClient.GetEntityName(msg.User) + " " + h.slackClient.GetEntityName(msg.Data.Name) + "!\n"
	//ChannelJoinGreetingBeginning = h.cfg.ChannelJoinGreetingBeginning + " - " + h.slackClient.GetEntityName(msg.Data.User) + "!\n"
	//h.slackClient.SendMessage(msg.Data.Channel, []string{}, ChannelJoinGreetingBeginning)
	//h.slackClient.SendReply(msg, ChannelJoinGreetingBeginning)
	h.slackClient.SendMessage(msg.Data.Channel, []string{}, ChannelJoinGreetingBeginning)
	h.slackClient.SendMessage(msg.Data.Channel, []string{}, ChannelJoinGreetingEnd)
}

func (h *handler) Execute(msg slack.Message) error {
	entityName := h.slackClient.GetEntityName(msg.RespondTo)
	log.Print("<- ", entityName, " ->")
	speaker := h.slackClient.GetEntityName(msg.Data.User)
	if strings.HasSuffix(msg.Data.Text, "has joined the channel") {
		log.Print("Joined the channel:", speaker)
		TeamMembers := strings.Split(h.cfg.TeamMembers, " ")
		log.Print("Team members:", TeamMembers)
		if stringInSlice(h.slackClient.GetEntityName(msg.Data.User), TeamMembers) {
			log.Print("a team member joined")
		} else {
			welcome(h, msg)
		}
		return nil
	}
	log.Print("now to key on response")
	switch msg.Data.Text {
	case "!welcome":
		log.Print("Processing '!welcome' request from @", h.slackClient.GetEntityName(msg.Data.User), " in #", h.slackClient.GetEntityName(msg.RespondTo))
		welcome(h, msg)
	case "!help":
		log.Print("Processing '!help' request from @", h.slackClient.GetEntityName(msg.Data.User), " in #", h.slackClient.GetEntityName(msg.RespondTo))
		h.slackClient.SendMessage(msg.Data.Channel, []string{}, "*!help* This message\n*!oncall* See who is on call\n")
	case "!oncall":
		log.Print("Processing '!oncall' request from @", h.slackClient.GetEntityName(msg.Data.User), " in #", h.slackClient.GetEntityName(msg.RespondTo))
		h.slackClient.SendMessage(msg.Data.Channel, []string{}, "• <https://wiki.twitch.com/display/VID/2018+Holiday+Coverage+Calendar|*Oncall*> for escalation and Slack questions\n")
	case "!hello":
		log.Print("Processing '!hello' request from @", h.slackClient.GetEntityName(msg.Data.User), " in #", h.slackClient.GetEntityName(msg.RespondTo))
		h.slackClient.SendReply(msg, "Hello!")
	}
	return nil
}

func (h *handler) Export() *expvar.Map {
	return &h.export.Map
}

// Stop is called when the app reloads.
func (h *handler) Stop() error {
	// Nothing to stop.
	return nil
}
