job {
  name 'video-coreservices-video-coreservices-slack-bot-build'
  using 'TEMPLATE-autobuild'

  scm {
    git {
      remote {
        github 'video-coreservices/video-coreservices-slack-bot', 'ssh', 'git.xarth.tv'
        credentials 'git-aws-read-key'
      }
    }
  }

  steps {
    shell 'make TAG=$GIT_COMMIT'
    shell 'docker push docker-registry.internal.justin.tv/video-coreservices/video-coreservices-slack-bot:$GIT_COMMIT'
    shell 'docker push docker-registry.internal.justin.tv/video-coreservices/video-coreservices-slack-bot:latest'
    saveDeployArtifact 'video-coreservices/video-coreservices-slack-bot', '.'
  }
}

job {
  name 'video-coreservices-video-coreservices-slack-bot-deploy-stg'
  using 'TEMPLATE-minimal-skadi-deploy'

  wrappers {
    sshAgent 'git-aws-read-key'
    preBuildCleanup()
    timestamps()
    credentialsBinding {
      file('AWS_CONFIG_FILE', 'aws_config')
      string 'AWS_ACCESS_KEY_ID', 'video-ops-stg-access-key'
      string 'AWS_SECRET_ACCESS_KEY', 'video-ops-stg-secret-key'
    }
  }

  steps {
    downloadDeployArtifact 'video-coreservices/video-coreservices-slack-bot'
    shell 'curl https://packages.internal.justin.tv/artifactory/ip-video-ota-generic/services/vidops-cops-scripts/stage/deploy | bash -s -- -a apply -e $ENVIRONMENT'
  }
}
