package jira

import (
	"github.com/andygrunwald/go-jira"
	"io"
)

// Config for the JIRA package
type Config struct {
	JiraBaseURL            string `toml:"base_url"`
	JiraAccessToken        string `toml:"access_token"`
	JiraAccessTokenSecret  string `toml:"access_token_secret"`
	JiraConsumerKey        string `toml:"consumer_key"`
	JiraPrivateKeyLocation string `toml:"private_key_location"`
	jira                   *jira.Client
}

// Client redefines goJira.Client to allow custom methods and easier data mocking for tests.
// If any of this changes, counterfeiter must be re-run.
type Client interface {
	GetTicket(ticketKey string) (*Ticket, error)
	GetOpenTickets(projectKey string) ([]*Ticket, error)
	CreateTicket(jiraTicket *Ticket) error
	AttachFile(ticketKey string, reader io.Reader, attachmentName string) error
	TransitionTicket(ticketKey string, transitionID string) error
}

// Ticket is the data needed to make a new task.
type Ticket struct {
	TicketKey   string
	ProjectKey  string
	Summary     string
	Description string
	IssueType   string
	URL         string
	Status      string
}
