package jira

import (
	"github.com/stretchr/testify/assert"
	"testing"
)

// This only does a partial cover because we have no slack connection in tests.
func TestGetJIRACliente(t *testing.T) {
	a := assert.New(t)
	config := &Config{
		JiraPrivateKeyLocation: "/tmp/missing",
		JiraConsumerKey:        "foo",
		JiraBaseURL:            "bar",
		JiraAccessToken:        "baz",
		JiraAccessTokenSecret:  "der",
	}
	err := config.getJIRAClient()
	a.Nil(config.jira, "missing key file must produce a nil pointer reference")
	a.Contains(err.Error(), "reading private key file", "wrong error message returned")
	// write more (change config and run it again). remove reference below when finished.
}

/*
func getJIRAClient(config *Config) (*goJira.Client, error) {
	ctx := context.Background()
	var oauthConfig *oauth1.Config

	if privateKeyBytes, err := ioutil.ReadFile(config.JiraPrivateKeyLocation); err != nil {
		return nil, errors.Wrap(err, "reading private key file")
	} else if keyDERBlock, _ := pem.Decode(privateKeyBytes); keyDERBlock == nil {
		return nil, errors.Errorf("error decoding key PEM block in %v", config.JiraPrivateKeyLocation)
	} else if !(keyDERBlock.Type == "PRIVATE KEY" || strings.HasSuffix(keyDERBlock.Type, " PRIVATE KEY")) {
		return nil, errors.Errorf("unexpected key DER block type %v", keyDERBlock.Type)
	} else if privateKey, err := x509.ParsePKCS1PrivateKey(keyDERBlock.Bytes); err != nil {
		return nil, errors.Wrap(err, "parsing PKCS1 private key")
	} else {
		oauthConfig = &oauth1.Config{
			ConsumerKey: config.JiraConsumerKey,
			Signer:      &oauth1.RSASigner{PrivateKey: privateKey},
		}
	}

	httpClient := oauth1.NewClient(ctx, oauthConfig, oauth1.NewToken(config.JiraAccessToken, config.JiraAccessTokenSecret))
	newClient, err := goJira.NewClient(httpClient, config.JiraBaseURL)
	if err != nil {
		return nil, errors.Wrap(err, "creating new Jira Client")
	}

	return newClient, nil
}
*/
