package pagerduty

// Client redefines goPd.Client to allow custom methods and easier data mocking for tests.
// If any of this changes, counterfeiter must be re-run.
type Client interface {
	ListServices() ([]Service, error)
	ListEscalationPolicies() ([]EscalationPolicy, error)
	GetIntegration(serviceID string, integrationID string) (Integration, error)
	ListOnCalls() ([]OnCall, error)
}

// Service is an object representing a PagerDuty service
type Service struct {
	ID           string
	Name         string
	Description  string
	Integrations []ObjectReference
}

// EscalationPolicy is an object representing a PagerDuty escalation policy
type EscalationPolicy struct {
	ID       string
	Summary  string
	Services []ObjectReference
}

// Integration is an object representing a PagerDuty integration
type Integration struct {
	ID               string
	Type             string
	IntegrationEmail string
}

// OnCall is an object representing a PagerDuty oncall object
type OnCall struct {
	EscalationLevel  uint
	EscalationPolicy ObjectReference
	UserSummary      string
	ScheduleID       string
	UserType         string
	UserID           string
}

// ObjectReference is an object representing a generic object reference in the PagerDuty API
type ObjectReference struct {
	ID      string
	Summary string
	Type    string
}
