package slack

import (
	// standard
	"testing"

	// external
	goslack "github.com/nlopes/slack"
	"github.com/stretchr/testify/assert"
)

func testConfig() Config {
	return Config{
		APIToken:     "api_token",
		DebugChannel: "debug_channel",
		LogDir:       "log_dir",
	}
}

// This only does a partial cover because we have no slack connection in tests.
func TestGetUserName(t *testing.T) {
	a := assert.New(t)
	config := testConfig()
	config.users = slackUsers{List: []goslack.User{
		{Name: "test_user", ID: "U123456"},
		{Name: "test_user2", ID: "U7891011"},
		{Name: "test_user3", ID: "U121314"},
	}}
	a.EqualValues("test_user", config.GetEntityName("U123456"), "wrong username returned")
	a.EqualValues("<error_generating_entity_name>", config.GetEntityName("MISSING"), "wrong error message returned")
}

// This only does a partial cover because we have no slack connection in tests.
func TestGetChanName(t *testing.T) {
	a := assert.New(t)
	config := testConfig()
	a.EqualValues("<error_generating_entity_name>", config.GetEntityName("MISSING"), "wrong error message returned")
	// No idea how to test anything else since goslack.Channel type is all filtered.
	// Can't figure out how to Mock data for this library.
}
