# voncount

A metrics aggregation architecture for delivering statistics over Carbon. This enabled services to send their metrics to a hosted carbon-compatible and graphite-compatible metrics provider.

![Count Von Count](docs/thecount.jpg)

The main goal of this repo is to provide configuration and docker builds for a useful configuration of a combination of open-source and twitch-built components that when composed together allow high-throughput (millions of TPS) incremented and high cardinality (hundreds of thousands of series) data to be aggregated and sent to downstream graphites

## Components

Voncount is a tiered solution for scalability and has three main components:

 1. [**go-statsd-proxy**](https://git.xarth.tv/edge/go-statsd-proxy) takes udp metrics requests in the statsd format and distributes them across a consistent hashing pool of statsd instances

 2. [**statsite**](docs/statsite.md) is a high-throughput statsd replacement that aggregates sharded statistics.

    * [**Plumbago**](https://git.xarth.tv/edge/plumbago) is a replacement emitter for graphite stats with better throughput and observability.

 3. [**carbon-relay-ng**](docs/carbon-relay-ng.md) buffers and sends statistics in the graphite(carbon) protocol to one or multiple downstreams.

## Operations

* [Logs and metrics for voncount itself](https://grafana.xarth.tv/d/rmAtxD9Wz/metrics-pipeline-voncount?orgId=1&refresh=10s)
* [ECR terraform](https://git.xarth.tv/edge/graphql/blob/63c2cb1e2bf80cf0a74d9ea2f189c75be5cdf83e/terraform/accounts/twitch-graphql-prod/main.tf#L59-L85)
* [Cluster terraform](https://git.xarth.tv/edge/graphql/blob/63c2cb1e2bf80cf0a74d9ea2f189c75be5cdf83e/terraform/accounts/twitch-graphql-prod/main.tf#L340-L439)

## Deployment

See [**deploy**](docs/deploy.md)
