#!/bin/bash

set -ue

PKG_DIR=/opt/twitch/infoblox-snmp-collector
SCRIPT_DIR=$(dirname $(realpath $0))
PACKER_VERSION=1.6.5
PACKER=${SCRIPT_DIR}/packer

[ -z "${PACKER_BUILD_NAME:-}" ] && {
    cd $SCRIPT_DIR
    until [ -x $PACKER ] && [ "$($PACKER --version)" = "$PACKER_VERSION" ]; do
        wget -cqO /tmp/packer_${PACKER_VERSION}_linux_amd64.zip "https://releases.hashicorp.com/packer/${PACKER_VERSION}/packer_${PACKER_VERSION}_linux_amd64.zip"
        unzip /tmp/packer_${PACKER_VERSION}_linux_amd64.zip
    done
    $PACKER build -color=false packer.json
    exit
}

DEBIAN_FRONTEND=noninteractive apt-get update && apt-get install -y wget 
build_dir=$(mktemp -d)
cp -r $SCRIPT_DIR/root/* $build_dir/
wget -qO- https://apache.osuosl.org/zookeeper/zookeeper-3.6.2/apache-zookeeper-3.6.2-bin.tar.gz|tar kxzf - --strip 1 -C $build_dir/opt/zookeeper
chmod -R go-w $build_dir/
chown -R root:root $build_dir/
. <(grep -E "^(Package|Version|Architecture):" $build_dir/DEBIAN/control |sed -e 's/: \(.*\)/="\1"/')
deb_name=${Package}_${Version}_${Architecture}.deb
dpkg-deb -b $build_dir $SCRIPT_DIR/$deb_name
chown --reference=/build/ /build/$deb_name
