# docker-alerta

Custom docker build used by alerta fargate tasks for the video-monitoring team.

## What's so custom and why build it custom

Most docker build components borrowed from https://github.com/alerta/docker-alerta with some changes

* Install pip packages from our upstream (pypi in artifactory).
* Change method to install plugins to use requirements.txt and artifactory upstreams.
* Additional dependency installation for ldap compatability.

It's important we build this locally and not rely on the public, upstream image because by default, the image is built with all plugins in the latest (master) version installed. We want to control plugin CI/CD with the monitoring project so starting with the upstream docker image was a non-starter.

## Workflow

Each push to master will trigger a jenkins build job that builds the docker image and uploads it to our internal docker-registry.

## Build Locally

Make sure you have docker and docker-compose installed.

To test whether the image can build:
```
make local
```

To test whether you can run the built image with a mongo backend locally:
```
make run_local
```

## Interact With Your Local Build

Go to `localhost:8080` and the WebUI should run. Go to the API Keys page and copy the following into `~/.alerta.conf`
```
[profile development]
endpoint = http://localhost:8080/api
key = <the_key_for_the_admin@alerta.io>
```

To test some API functionality, install the [alerta CLI](https://docs.alerta.io/en/latest/cli.html#installation) and set the following environment variables
```
export ALERTA_CONF_FILE=~/.alerta.conf
export ALERTA_DEFAULT_PROFILE=development
```

From here, you should be able to use the alerta CLI queries. Please refer to [the CLI documentation](https://docs.alerta.io/en/latest/cli.html#commands) to see how to run commands to test.

## Alerta Plugin Development

If you would like to test your custom plugin you just built:

1. If the plugin is already packaged and built to artifactory, simply add your plugin and version requirement to `plugin-requirements.txt` normally.
2. If your plugin isn't built in artifactory yet and you'd like to trial test your new code locally, you can specify your requirement to `plugin-requirements.txt` to build from [git directly](https://stackoverflow.com/questions/16584552/how-to-state-in-requirements-txt-a-direct-github-source/34518202#34518202).
  * so something like `git+git://git-aws.internal.justin.tv/video-monitoring/my-alerta-plugin@<branch_commit_hash>#egg=<the_package_name>`

## Additional Documentation
[Alerta Documentation](http://docs.alerta.io/en/latest/)
