resource "aws_db_parameter_group" "alerta_db_parameter_group" {
  name        = "alerta-parameter-group"
  family      = "aurora-postgresql10"
  description = "alerta-parameter-group"
}

resource "aws_rds_cluster_parameter_group" "alerta_db_cluster_parameter_group" {
  name        = "alerta-cluster-parameter-group"
  family      = "aurora-postgresql10"
  description = "alert-cluster-parameter-group"
}

module "alerta_db" {
  source        = "./vendor/modules/terraform-aws-rds-aurora"
  name          = "alerta"
  database_name = "alerta"

  engine                = "aurora-postgresql"
  engine_version        = "10.7"
  engine_mode           = "serverless"
  replica_scale_enabled = false
  replica_count         = 0

  vpc_id  = module.variables.vpc_id
  subnets = module.variables.private_subnet_ids

  allowed_security_groups      = [module.variables.sg_twitch_subnet_id]
  allowed_cidr_blocks          = ["10.0.0.0/8"]
  instance_type                = "db.r4.large"
  storage_encrypted            = true
  apply_immediately            = true
  monitoring_interval          = 10
  performance_insights_enabled = true

  db_parameter_group_name         = aws_db_parameter_group.alerta_db_parameter_group.id
  db_cluster_parameter_group_name = aws_rds_cluster_parameter_group.alerta_db_cluster_parameter_group.id
  scaling_configuration = {
    auto_pause               = true
    max_capacity             = 64
    min_capacity             = 8
    seconds_until_auto_pause = 300
    timeout_action           = "ForceApplyCapacityChange"
  }
}
