resource "aws_ssm_parameter" "alerta_rds_connection_string" {
  name        = module.shared_vars.ssm_rds_conn_string
  description = "DB connection string for the Alerta RDS instance"
  type        = "SecureString"
  value       = "postgresql://${module.alerta_db.this_rds_cluster_master_username}:${module.alerta_db.this_rds_cluster_master_password}@${module.alerta_db.this_rds_cluster_endpoint}/${module.alerta_db.this_rds_cluster_database_name}?connect_timeout=10&application_name=alerta"

  tags = {
    environment = local.environment
  }
}

resource "aws_ssm_parameter" "alerta_rds_secret" {
  name        = "/${local.environment}/alerta_rds/password/master"
  description = "Password for the Alerta RDS instance"
  type        = "SecureString"
  value       = module.alerta_db.this_rds_cluster_master_password

  tags = {
    environment = var.env
  }
}
