# Alerta Deploy Module

This module includes the resources needed to spin up Alerta's continuous deployment mechanism, which is kickstarted by a Jenkins hook on merge to the master branch of this repository. The Jenkins job sends this repository's contents to S3, which has a CodeBuild polling hook configured that triggers a container build. The output container is stored in an ECR repository configured by this module, which then triggers a blue-green ECS deployment with the new task. 

Since this deployment requires the entire Alerta infra to be spun up first, this module should be run **after** the `db` and `infra` modules.

## Getting Started

1. Clone the repository

2. Download the following (assuming MacOS)

  * [tfenv](https://github.com/tfutils/tfenv#automatic) --> `brew install tfenv`
  * [terrafile](https://github.com/coretech/terrafile#how-to-install) --> `brew tap coretech/terrafile && brew install terrafile`

3. Copy the credentials for your AWS account in your shell (i.e: isengard temporary creds, other mechanisms)

4. See if your terraform environment can set up. In the same folder as this README, run `./deploy.sh -e [staging|prod] -r <aws_region> (plan|apply)`
