resource "aws_codebuild_project" "alerta_codebuild_project" {
  name          = "alerta-build"
  description   = "Builds the alerta docker container to be used in ECS"
  build_timeout = "5"
  service_role  = aws_iam_role.alerta_codebuild_role.arn

  artifacts {
    type = "NO_ARTIFACTS"
  }

  environment {
    compute_type    = "BUILD_GENERAL1_SMALL"
    image           = "aws/codebuild/standard:3.0-19.11.26"
    type            = "LINUX_CONTAINER"
    privileged_mode = "true"
  }

  source {
    type     = "S3"
    location = "${aws_s3_bucket.docker_alerta_codesource_bucket.bucket}/master"
  }

  vpc_config {
    vpc_id             = module.variables.vpc_id
    subnets            = module.variables.private_subnet_ids
    security_group_ids = [module.variables.sg_twitch_subnet_id]
  }

  tags = local.common_tags
}
