data "terraform_remote_state" "alerta_infra_lb" {
  backend = "s3"

  config = {
    bucket = "twitch-video-ops-stg-tf-state"
    key    = "services/docker-alerta-infra/us-west-2/terraform.tfstate"
    region = var.region
  }
}

resource "aws_codedeploy_app" "alerta_codedeploy_app" {
  compute_platform = "ECS"
  name             = "alerta-codedeploy"
}

resource "aws_codedeploy_deployment_group" "alerta_codedeploy_group" {
  app_name               = aws_codedeploy_app.alerta_codedeploy_app.name
  deployment_group_name  = var.deployment_group_name
  service_role_arn       = aws_iam_role.alerta_codedeploy_role.arn
  deployment_config_name = "CodeDeployDefault.ECSAllAtOnce"

  ecs_service {
    cluster_name = module.shared_vars.ecs_cluster_name
    service_name = module.shared_vars.ecs_service_name
  }

  auto_rollback_configuration {
    enabled = true
    events  = ["DEPLOYMENT_FAILURE"]
  }

  blue_green_deployment_config {
    deployment_ready_option {
      action_on_timeout = "CONTINUE_DEPLOYMENT"
    }

    terminate_blue_instances_on_deployment_success {
      action                           = "TERMINATE"
      termination_wait_time_in_minutes = 10
    }
  }

  deployment_style {
    deployment_option = "WITH_TRAFFIC_CONTROL"
    deployment_type   = "BLUE_GREEN"
  }

  load_balancer_info {
    target_group_pair_info {
      prod_traffic_route {
        listener_arns = [data.terraform_remote_state.alerta_infra_lb.outputs.alerta_lb_listener_arn]
      }

      target_group {
        name = module.shared_vars.lb_tg_blue
      }

      target_group {
        name = module.shared_vars.lb_tg_green
      }
    }
  }

}
