resource "aws_codepipeline" "alerta_codepipeline" {
  name     = "alerta-pipeline"
  role_arn = aws_iam_role.alerta_codepipeline_role.arn

  artifact_store {
    location = "${aws_s3_bucket.docker_alerta_codepipeline_bucket.bucket}"
    type     = "S3"
  }


  stage {
    name = "Source"

    action {
      name             = "PullUpdatesFromS3"
      category         = "Source"
      owner            = "AWS"
      provider         = "S3"
      version          = "1"
      output_artifacts = ["SourceArtifact"]

      configuration = {
        PollForSourceChanges = "true"
        S3Bucket             = aws_s3_bucket.docker_alerta_codesource_bucket.id
        S3ObjectKey          = "master/SourceArtifact.zip"
      }
    }
  }

  stage {
    name = "Build"

    action {
      name             = "BuildAlertaDockerImage"
      category         = "Build"
      owner            = "AWS"
      provider         = "CodeBuild"
      input_artifacts  = ["SourceArtifact"]
      output_artifacts = ["BuildArtifact"]
      version          = "1"

      configuration = {
        ProjectName = aws_codebuild_project.alerta_codebuild_project.name
      }
    }
  }

  stage {
    name = "Deploy"

    action {
      name            = "BlueGreenDeploy"
      category        = "Deploy"
      owner           = "AWS"
      provider        = "CodeDeployToECS"
      input_artifacts = ["BuildArtifact"]
      version         = "1"

      configuration = {
        AppSpecTemplateArtifact        = "BuildArtifact",
        AppSpecTemplatePath            = "appspec.yaml",
        ApplicationName                = aws_codedeploy_app.alerta_codedeploy_app.name,
        DeploymentGroupName            = var.deployment_group_name,
        Image1ArtifactName             = "BuildArtifact",
        Image1ContainerName            = "IMAGE_NAME",
        TaskDefinitionTemplateArtifact = "BuildArtifact"
      }
    }
  }
}
