# Alerta Infra module

This module contains the resources needed to spin up the bulk of the infra that supports the Alerta application. This includes bootstrapping the ECS service, configuring load balancing, DNS discoverability, and autoscaling.

**This module is only intended to be run once per region, per account**. The reason behind this is because once terraform bootstraps the ECS resources (such as the task definition), further modifications to the task definition will automatically be triggered and updated by the deployment pipeline. 

If one must update a resource included in this module (which generally should not be necessary), please make sure to target which resources should be updated by using the `--target <resource>` flag. 

The following resources should **never** be modified by terraform following bootstrapping:

```
- aws_ecs_service.alerta_service
- aws_ecs_task_definition.alerta_defn
* aws_appautoscaling_target.alerta_target (this shows up as an update each time. Probably a tf bug)
```

## Getting Started

1. Clone the repository

2. Download the following (assuming MacOS)

  * [tfenv](https://github.com/tfutils/tfenv#automatic) --> `brew install tfenv`
  * [terrafile](https://github.com/coretech/terrafile#how-to-install) --> `brew tap coretech/terrafile && brew install terrafile`

3. Copy the credentials for your AWS account in your shell (i.e: isengard temporary creds, other mechanisms)

4. See if your terraform environment can set up. In the same folder as this README, run `./deploy.sh -e [staging|prod] -r <aws_region> (plan|apply)`
