resource "aws_appautoscaling_target" "alerta_target" {
  service_namespace  = "ecs"
  resource_id        = "service/${aws_ecs_cluster.alerta_cluster.name}/${aws_ecs_service.alerta_service.name}"
  scalable_dimension = "ecs:service:DesiredCount"
  role_arn           = aws_iam_role.ecs_auto_scale_role.arn
  min_capacity       = 3
  max_capacity       = 10

  depends_on = [aws_iam_role.ecs_auto_scale_role]
}

# Automatically scale capacity up by one
resource "aws_appautoscaling_policy" "alerta_up" {
  name               = "alerta_scale_up"
  service_namespace  = "ecs"
  resource_id        = "service/${aws_ecs_cluster.alerta_cluster.name}/${aws_ecs_service.alerta_service.name}"
  scalable_dimension = "ecs:service:DesiredCount"

  step_scaling_policy_configuration {
    adjustment_type         = "ChangeInCapacity"
    cooldown                = 60
    metric_aggregation_type = "Maximum"

    step_adjustment {
      metric_interval_lower_bound = 0
      scaling_adjustment          = 1
    }
  }

  depends_on = [aws_appautoscaling_target.alerta_target]
}

# Automatically scale capacity down by one
resource "aws_appautoscaling_policy" "alerta_down" {
  name               = "alerta_scale_down"
  service_namespace  = "ecs"
  resource_id        = "service/${aws_ecs_cluster.alerta_cluster.name}/${aws_ecs_service.alerta_service.name}"
  scalable_dimension = "ecs:service:DesiredCount"

  step_scaling_policy_configuration {
    adjustment_type         = "ChangeInCapacity"
    cooldown                = 60
    metric_aggregation_type = "Maximum"

    step_adjustment {
      metric_interval_lower_bound = 0
      scaling_adjustment          = -1
    }
  }

  depends_on = [aws_appautoscaling_target.alerta_target]
}
